/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.world;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import sekelsta.horse_colors.HorseColors;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.ModEntities;

@Mod.EventBusSubscriber(modid="horse_colors")
public class Spawns {
    @SubscribeEvent
    public static void onLoadComplete(FMLLoadCompleteEvent e) {
        Spawns.changeVillageAnimals();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addBiomeSpawns(BiomeLoadingEvent event) {
        int horsePlainsWeight = (int)Math.round(5.0 * (Double)HorseConfig.Spawn.horseSpawnMultiplier.get());
        MobSpawnInfo.Spawners horsePlainsSpawner = new MobSpawnInfo.Spawners(ModEntities.HORSE_GENETIC, horsePlainsWeight, 2, 6);
        int horseSavannaWeight = (int)Math.round(1.0 * (Double)HorseConfig.Spawn.horseSpawnMultiplier.get());
        MobSpawnInfo.Spawners horseSavannaSpawner = new MobSpawnInfo.Spawners(ModEntities.HORSE_GENETIC, horseSavannaWeight, 2, 6);
        List spawns = event.getSpawns().getSpawner(EntityClassification.CREATURE);
        if (event.getCategory() == Biome.Category.PLAINS) {
            spawns.add(horsePlainsSpawner);
        } else if (event.getCategory() == Biome.Category.SAVANNA) {
            spawns.add(horseSavannaSpawner);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void removeBiomeSpawns(BiomeLoadingEvent event) {
        ArrayList<MobSpawnInfo.Spawners> entriesToRemove = new ArrayList<MobSpawnInfo.Spawners>();
        List originalSpawns = event.getSpawns().getSpawner(EntityClassification.CREATURE);
        for (MobSpawnInfo.Spawners entry : originalSpawns) {
            if (entry.field_242588_c != EntityType.field_200762_B) continue;
            if (!((Boolean)HorseConfig.Spawn.blockVanillaHorseSpawns.get()).booleanValue()) continue;
            HorseColors.logger.debug("Removing vanilla horse spawn: " + entry);
            entriesToRemove.add(entry);
        }
        for (MobSpawnInfo.Spawners entry : entriesToRemove) {
            originalSpawns.remove(entry);
        }
    }

    private static boolean isVanillaVillageHorsePiece(SingleJigsawPiece piece) {
        return piece.toString().contains("minecraft:village/common/animals/horses");
    }

    private static boolean keepJigsawPair(Pair<JigsawPiece, Integer> pair) {
        if (!((Boolean)HorseConfig.Spawn.blockVanillaHorseSpawns.get()).booleanValue()) {
            return true;
        }
        JigsawPiece piece = (JigsawPiece)pair.getFirst();
        if (piece instanceof SingleJigsawPiece) {
            return !Spawns.isVanillaVillageHorsePiece((SingleJigsawPiece)piece);
        }
        return true;
    }

    public static void changeVillageAnimals() {
        PlainsVillagePools.func_214744_a();
        HorseColors.logger.debug("Modifying village animal spawns");
        ResourceLocation animalsLoc = new ResourceLocation("village/common/animals");
        Optional animalsOpt = WorldGenRegistries.field_243656_h.func_241873_b(animalsLoc);
        if (!animalsOpt.isPresent()) {
            System.err.println("Trying to overwrite village spawns too soon");
            return;
        }
        JigsawPattern animals = (JigsawPattern)animalsOpt.get();
        List vanillaList = (List)ObfuscationReflectionHelper.getPrivateValue(JigsawPattern.class, (Object)animals, (String)"field_214952_d");
        ArrayList<Pair> keeperList = new ArrayList<Pair>();
        for (Pair p : vanillaList) {
            if (!Spawns.keepJigsawPair((Pair<JigsawPiece, Integer>)p)) continue;
            keeperList.add(p);
        }
        ArrayList<Pair> customPieces = new ArrayList<Pair>();
        String modloc = "horse_colors:";
        customPieces.add(new Pair((Object)JigsawPiece.func_242849_a((String)(modloc + "village/common/animals/horses_1")), (Object)1));
        customPieces.add(new Pair((Object)JigsawPiece.func_242849_a((String)(modloc + "village/common/animals/horses_2")), (Object)1));
        customPieces.add(new Pair((Object)JigsawPiece.func_242849_a((String)(modloc + "village/common/animals/horses_3")), (Object)1));
        customPieces.add(new Pair((Object)JigsawPiece.func_242849_a((String)(modloc + "village/common/animals/horses_4")), (Object)1));
        customPieces.add(new Pair((Object)JigsawPiece.func_242849_a((String)(modloc + "village/common/animals/horses_5")), (Object)1));
        JigsawPattern.PlacementBehaviour placementBehaviour = JigsawPattern.PlacementBehaviour.RIGID;
        for (Pair pair : customPieces) {
            JigsawPiece jigsawPiece = (JigsawPiece)((Function)pair.getFirst()).apply(placementBehaviour);
            keeperList.add(new Pair((Object)jigsawPiece, pair.getSecond()));
        }
        JigsawPatternRegistry.func_244094_a((JigsawPattern)new JigsawPattern(animalsLoc, new ResourceLocation("empty"), keeperList));
    }
}

